unit uSplash;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls;

type
  TOpenMode = (omSplash, omAbout, omToDo);
  TfrmSplash = class(TForm)
    SplashImage: TImage;
    SplashLabel: TLabel;
    SplashBorder: TShape;
    SplashRich: TRichEdit;
    memoToDo: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSplash: TfrmSplash;
  OpenMode: TOpenMode;

implementation

{$R *.DFM}

{----------------------------------------------------------}
procedure TfrmSplash.FormCreate(Sender: TObject);
begin
	Case OpenMode of
  omSplash:
  	begin
    	BorderStyle := bsNone;
      Width := 399;
      Height := 288;
  		SplashLabel.Visible := True;
      SplashRich.Visible := False;
      memoToDo.Visible := False;
    end;
  omAbout:
  	begin
    	BorderStyle := bsDialog;
      BorderIcons := [biSystemMenu];
			SplashRich.PlainText := False;
			SplashRich.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+'HelpAbout.rtf');
      SplashRich.SelStart := Length(SplashRich.Text);
  		SplashLabel.Visible := False;
      memoToDo.Visible := False;
      SplashRich.Visible := True;
    end;
  omToDo:
  	begin
    	BorderStyle := bsDialog;
      BorderIcons := [biSystemMenu];
      memoToDo.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+'Todo.txt');
      memoToDo.Visible := True;
  		SplashLabel.Visible := False;
      SplashRich.Visible := False;
    end;
  end;
end;

{----------------------------------------------------------}
procedure TfrmSplash.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	if OpenMode = omToDo then
  	memoToDo.Lines.SaveToFile(ExtractFilePath(Application.ExeName)+'Todo.txt');
  Action := caFree;
end;

{----------------------------------------------------------}
end.
{----------------------------------------------------------}

