unit uQuery;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Db, DBTables, Grids, DBGrids, StdCtrls;

type
  TfrmQuery = class(TForm)
    memoQuery: TMemo;
    dbgridQuery: TDBGrid;
    SQLQuery: TQuery;
    dsQuery: TDataSource;
    splitQuery: TSplitter;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure memoQueryChange(Sender: TObject);
  private
    { Private declarations }
  public
		{ Public declarations }
		Dirty : boolean;
		procedure UpdateCaption;
	end;

var
	frmQuery: TfrmQuery;
	QueryName: string;

implementation

uses uMain, uDataMod;

{$R *.DFM}

{----------------------------------------------------------}
procedure TfrmQuery.UpdateCaption;
begin
	If QueryName = '' then
		Caption := 'Query: New Query'
	Else
		Caption := 'Query: ' + ExtractFileName(QueryName);
	frmMain.dbNav.DataSource := dsQuery;
end;

{----------------------------------------------------------}
procedure TfrmQuery.FormCreate(Sender: TObject);
begin
	UpdateCaption;
	Dirty := False;
end;

{----------------------------------------------------------}
procedure TfrmQuery.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	If Dirty then
		Case MessageDlg('You have not saved this Query. Do you want to save it now?', mtConfirmation, mbYesNoCancel, 0) of
			mrYes:	frmMain.mnuQuerySaveClick(Sender);
			mrNo: {Do Nothing};
			mrCancel: Exit;
		end;
	SQLQuery.Active := False;
	frmMain.dbNav.DataSource := Nil;
  QueryName := '';
	Action := caFree;
end;

{----------------------------------------------------------}
procedure TfrmQuery.FormActivate(Sender: TObject);
begin
	if SQLQuery.Active then
  begin
		frmMain.dbNav.DataSource := dsQuery;
  end;
end;

{----------------------------------------------------------}
procedure TfrmQuery.memoQueryChange(Sender: TObject);
begin
	If memoQuery.Modified then
		if not(Dirty) then
		begin
			Caption := Caption + ' *';
			Dirty := True;
		end;
end;

{----------------------------------------------------------}
end.
{----------------------------------------------------------}
