unit uCreateEventType;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, StdCtrls, Buttons, Mask, DBCtrls, DBCGrids, ExtCtrls,
  Grids, DBGrids, ComCtrls;

type
  TfrmCreateEventType = class(TForm)
    bitbtnOK: TBitBtn;
    bitbtnCancel: TBitBtn;
    tblEventType: TTable;
    dsEventType: TDataSource;
    dsEventFields: TDataSource;
    sqlEventFields: TQuery;
    pgcontCreateEvent: TPageControl;
    tabDescription: TTabSheet;
    tabNotes: TTabSheet;
    tabOther: TTabSheet;
    dbcgridAdditionalInformation: TDBCtrlGrid;
    lblFieldNum: TLabel;
    lblFieldName: TLabel;
    lblFieldType: TLabel;
    lblDisplayFormat: TLabel;
    dbedFieldNum: TDBEdit;
    dbedFieldName: TDBEdit;
    dbedFieldType: TDBEdit;
    dbedDisplayFormat: TDBEdit;
    bitbtnAdd: TBitBtn;
    bitbtnDelete: TBitBtn;
    dbgEventType: TDBGrid;
    dbNavEventType: TDBNavigator;
    dbmemoNotes: TDBMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bitbtnAddClick(Sender: TObject);
    procedure bitbtnDeleteClick(Sender: TObject);
    procedure bitbtnOKClick(Sender: TObject);
    procedure bitbtnCancelClick(Sender: TObject);
  private
    { Private declarations }
	public
		{ Public declarations }
	end;

var
	frmCreateEventType: TfrmCreateEventType;

implementation

{$R *.DFM}

uses uDataMod;

{----------------------------------------------------------}
procedure TfrmCreateEventType.FormCreate(Sender: TObject);
begin
	tblEventType.Active := True;
	sqlEventFields.Active := True;
end;

{----------------------------------------------------------}
procedure TfrmCreateEventType.FormClose(Sender: TObject;
	var Action: TCloseAction);
begin
	tblEventType.Active := False;
	sqlEventFields.Active := False;
	Action := caFree;
end;

{----------------------------------------------------------}
procedure TfrmCreateEventType.bitbtnAddClick(Sender: TObject);
var
	Num: LongInt;
begin
	sqlEventFields.Last;
	if Not sqlEventFields.BOF then
		Num := sqlEventFields['FieldNum']+1
	else
		Num := 0;
	sqlEventFields.Append;
	sqlEventFields['FieldNum'] := Num;
	sqlEventFields['TypeID'] := tblEventType['TypeID'];
	sqlEventFields.Post;
	sqlEventFields.Close;
	sqlEventFields.Open;
	sqlEventFields.Last;
	dbedFieldNum.Enabled := True;
	dbedFieldName.Enabled := True;
	dbedFieldType.Enabled := True;
	dbedDisplayFormat.Enabled := True;
end;

{----------------------------------------------------------}
procedure TfrmCreateEventType.bitbtnDeleteClick(Sender: TObject);
begin
	if MessageDlg('Are you sure you want to delete this record?',
		mtWarning, [mbYes, mbNo], 0) = mrYes then
		sqlEventFields.Delete;
end;

{----------------------------------------------------------}
procedure TfrmCreateEventType.bitbtnOKClick(Sender: TObject);
begin
	if tblEventType.State = dsEdit then
  	tblEventType.Post;
	if sqlEventFields.State = dsEdit then
		sqlEventFields.Post;
end;

{----------------------------------------------------------}
procedure TfrmCreateEventType.bitbtnCancelClick(Sender: TObject);
begin
	if tblEventType.State = dsEdit then
  	tblEventType.Cancel;
	if sqlEventFields.State = dsEdit then
		sqlEventFields.Cancel;
end;

{----------------------------------------------------------}
end.
{----------------------------------------------------------}
