unit uCreateAssetType;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, DBCtrls, Db, DBTables, Grids, DBGrids, Mask,
  DBCGrids, Dialogs, ComCtrls;

type
  TfrmCreateAssetType = class(TForm)
    bitbtnOK: TBitBtn;
    bitbtnCancel: TBitBtn;
    tblEquip1: TTable;
    dsEquip1: TDataSource;
    tblEquip2: TTable;
    dsEquip2: TDataSource;
    dsAssetFields: TDataSource;
    sqlAssetFields: TQuery;
    pgcontCreateAssetType: TPageControl;
    tabEquip1: TTabSheet;
    tabEquip2: TTabSheet;
    tabOtherInfo: TTabSheet;
    dbgEquip1: TDBGrid;
    dbNavEquip1: TDBNavigator;
    dbgEquip2: TDBGrid;
    dbnavEquip2: TDBNavigator;
    dbcgridAdditionalInformation: TDBCtrlGrid;
    lblFieldNum: TLabel;
    lblFieldName: TLabel;
    lblFieldType: TLabel;
    lblDisplayFormat: TLabel;
    dbedFieldNum: TDBEdit;
    dbedFieldName: TDBEdit;
    dbedFieldType: TDBEdit;
    dbedDisplayFormat: TDBEdit;
    bitbtnAdd: TBitBtn;
    bitbtnDelete: TBitBtn;
    tblFieldTypes: TTable;
    dsFieldTypes: TDataSource;
    DBLookupComboBox1: TDBLookupComboBox;
    DBGrid1: TDBGrid;
    sqlAssetFieldsFieldNum: TSmallintField;
    sqlAssetFieldsFieldName: TStringField;
    sqlAssetFieldsFieldType: TStringField;
    sqlAssetFieldsDisplayFormat: TStringField;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bitbtnAddClick(Sender: TObject);
    procedure bitbtnDeleteClick(Sender: TObject);
    procedure bitbtnOKClick(Sender: TObject);
    procedure bitbtnCancelClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCreateAssetType: TfrmCreateAssetType;

implementation

{$R *.DFM}

uses uDataMod;

{----------------------------------------------------------}
procedure TfrmCreateAssetType.FormCreate(Sender: TObject);
begin
	pgcontCreateAssetType.ActivePage := tabEquip1;
	tblEquip1.Active := True;
	tblEquip2.Active := True;
	sqlAssetFields.Active := True;
end;

{----------------------------------------------------------}
procedure TfrmCreateAssetType.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
	tblEquip1.Active := False;
	tblEquip2.Active := False;
	sqlAssetFields.Active := False;
  Action := caFree;
end;

{----------------------------------------------------------}
procedure TfrmCreateAssetType.bitbtnAddClick(Sender: TObject);
var
	Num: LongInt;
begin
	sqlAssetFields.Last;
	if Not sqlAssetFields.BOF then
		Num := sqlAssetFields['FieldNum']+1
	else
		Num := 0;
	sqlAssetFields.Append;
	sqlAssetFields['FieldNum'] := Num;
	sqlAssetFields['Equip1'] := tblEquip2['Equip1Code'];
	sqlAssetFields['Equip2'] := tblEquip2['Equip2Code'];
	sqlAssetFields.Post;
	sqlAssetFields.Close;
	sqlAssetFields.Open;
	sqlAssetFields.Last;
	dbedFieldNum.Enabled := True;
	dbedFieldName.Enabled := True;
	dbedFieldType.Enabled := True;
	dbedDisplayFormat.Enabled := True;
end;

{----------------------------------------------------------}
procedure TfrmCreateAssetType.bitbtnDeleteClick(Sender: TObject);
begin
	if MessageDlg('Are you sure you want to delete this record?',
  	mtWarning, [mbYes, mbNo], 0) = mrYes then
		sqlAssetFields.Delete;
end;

{----------------------------------------------------------}
procedure TfrmCreateAssetType.bitbtnOKClick(Sender: TObject);
begin
	if tblEquip1.State = dsEdit then
  	tblEquip1.Post;
	if tblEquip2.State = dsEdit then
  	tblEquip2.Post;
	if sqlAssetFields.State = dsEdit then
		sqlAssetFields.Post;
end;

{----------------------------------------------------------}
procedure TfrmCreateAssetType.bitbtnCancelClick(Sender: TObject);
begin
	if tblEquip1.State = dsEdit then
  	tblEquip1.Cancel;
	if tblEquip2.State = dsEdit then
  	tblEquip2.Cancel;
	if sqlAssetFields.State = dsEdit then
		sqlAssetFields.Cancel;
end;

{----------------------------------------------------------}




end.
{----------------------------------------------------------}

