unit uODBC;

interface

uses
  Windows;

const 
    ODBC_NO_COMMAND = 0;
    ODBC_ADD_DSN = 1;
    ODBC_CONFIG_DSN = 2;
    ODBC_REMOVE_DSN = 3;
    ODBC_ADD_SYS_DSN = 4;
    ODBC_CONFIG_SYS_DSN = 5;
    ODBC_REMOVE_SYS_DSN = 6;

function InstallODBCDriver(dbfile:string):integer;

implementation

function SQLConfigDataSource(HWndParent:THandle;fRequest:integer; Driver,Attributes:PChar):integer; stdcall; external 'ODBCCP32.DLL';

function InstallODBCDriver(dbfile:string):integer;
begin
	result := SQLConfigDataSource(0,ODBC_ADD_SYS_DSN, 'Sybase SQL Anywhere 5.0', PChar('DBF=' 
    + PChar(dbfile) + #0
    + 'DSN=MyODBC_DSN' + #0
    + 'DESCRIPTION=Description of MyODBC_DSN' + #0
    + 'KeysInSQLStatistics=1' + #0
    + 'TranslationName=Sybase SQL Anywhere 5.0 Transl' + #0
    + 'TranslationOption=1' + #0
    + #0));
end;

(*
hwndParent := 0; { so we don't get the annoying configuration window.}
fRequest := ODBC_ADD_DSN; { This will add the datasource if it isn't already there, and will over-write the datasource if it is already there.}
lpszDriver := 'Microsoft Excel Driver (*.xls)' + #0; { As an example, though could be for any ODBC driver.}
lpszAttributes := 'DSN=abcdef' + #0 + { abcdef is the name you give the datasource.}
'DriverID=22' + #0 + { Excel specific, need to look into the driver you are using.}
'FIL=excel 5.0;' + #0 + { Again, refer to your driver.}
'DBQ=xxxxxx' + #- + { This is the file being opened. Again refer to your driver.}
'DefaultDir=xxxxxxxx' + #0 + #0; 
{ Yep, again refer to your driver. These are just the parameters 
that Excel needs. Each driver will be different. The key is to 
separate each with a #0, and finish it all of with #0 #0. The MS
Jet Help file is pretty good in this area, though the information is
buried, and is only of help for the MS datasources.}

Call the routine with

if SQLConfigDataSource( hwndParent, fRequest, @lpszDriver[1], @lpszAttributes[1])
then {we were successful}


From a data access point of view, do the following:

TDatabase
----------------
AliasName = 'abcdef' { Same as the DSN setting above.}
DatabaseName = 'odbc_MyDatabase'

TQuery or TTable
-------------------------
DatabaseName = 'odbc_MyDatabase'


Once you have done this, it's as though you have a normal BDE connection to
the ODBC database. I have found that not all ODBC databases support the
expected SQL standard, so you may need to look out for that.
*)

end.
