unit uEditAsset;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, ComCtrls, Buttons, Grids, DBGrids, Db, DBTables, ExtCtrls,
  DBCtrls;

type
  TfrmEditAsset = class(TForm)
    PageControl: TPageControl;
    tabNumber: TTabSheet;
    tabData: TTabSheet;
    bitbtnOK: TBitBtn;
    bitbtnCancel: TBitBtn;
    sqlEditAssets: TQuery;
    dsEditAssets: TDataSource;
    rgpSelectBy: TRadioGroup;
    gboxNumber: TGroupBox;
		maskAssetNum: TMaskEdit;
    gboxSelect: TGroupBox;
    gboxAssetsFound: TGroupBox;
    dbgEditAssets: TDBGrid;
    dbnavAssetsFound: TDBNavigator;
    BitBtn1: TBitBtn;
    gboxCommon: TGroupBox;
    gboxOther: TGroupBox;
    DBGrid1: TDBGrid;
    dsOther: TDataSource;
    lblNum: TLabel;
    dbedNum: TDBEdit;
    edAssetNum: TEdit;
    lblAssetNum: TLabel;
    lblStartDate: TLabel;
    dbedStartDate: TDBEdit;
    dbedUpdateDate: TDBEdit;
    lblUpdateDate: TLabel;
		lblDataGrade: TLabel;
		dbcomboDataGrade: TDBLookupComboBox;
    tblDataGrade: TTable;
    dsDataGrade: TDataSource;
    sqlOther: TQuery;
		procedure FormCreate(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure PageControlChange(Sender: TObject);
		procedure rgpSelectByClick(Sender: TObject);
		procedure BitBtn1Click(Sender: TObject);
    procedure sqlEditAssetsAfterScroll(DataSet: TDataSet);
    procedure bitbtnOKClick(Sender: TObject);
    procedure bitbtnCancelClick(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	frmEditAsset: TfrmEditAsset;

implementation

{$R *.DFM}

uses uMain, uDataMod;

{----------------------------------------------------------}
procedure TfrmEditAsset.FormCreate(Sender: TObject);
begin
	PageControl.ActivePage := tabNumber;
	sqlEditAssets.Open;
	sqlOther.Active := True;
	tblDataGrade.Active := True;
end;

{----------------------------------------------------------}
procedure TfrmEditAsset.FormClose(Sender: TObject;
	var Action: TCloseAction);
begin
	sqlEditAssets.Active := False;
	sqlOther.Active := False;
	tblDataGrade.Active := False;
	Action := caFree;
end;

{----------------------------------------------------------}
procedure TfrmEditAsset.PageControlChange(Sender: TObject);
Const
	CR = #10#13;
var
	SQL, P, N: string;
begin
	if PageControl.ActivePage = tabNumber then
 	begin
   	sqlEditAssets.Close;
  end;
	if PageControl.ActivePage = tabData then
	begin
		Screen.Cursor := crSQLWait;
		{ Build SQL Statement }
		N := maskAssetNum.EditText;
		SQL := '';
		P := Copy(N,1,1);
		if P <> '_' then
			SQL := SQL + ' RegionCode='''+P+'''';
		P := Copy(N,2,3);
		if Pos('_',P)=0 then
		begin
			if Length(SQL) > 0 then
				SQL := SQL + ' AND';
			SQL := SQL + ' SiteCode='''+P+'''';
		end;
		P := Copy(N,6,1);
		if P <> '_' then
		begin
			if Length(SQL) > 0 then
				SQL := SQL + ' AND';
			SQL := SQL + ' Sys1='''+P+'''';
		end;
		P := Copy(N,7,1);
		if P <> '_' then
		begin
			if Length(SQL) > 0 then
				SQL := SQL + ' AND';
			SQL := SQL + ' Sys2='''+P+'''';
		end;
		P := Copy(N,8,1);
		if P <> '_' then
		begin
			if Length(SQL) > 0 then
				SQL := SQL + ' AND';
			SQL := SQL + ' Sys3='''+P+'''';
		end;
		P := Copy(N,10,1);
		if P <> '_' then
		begin
			if Length(SQL) > 0 then
				SQL := SQL + ' AND';
			SQL := SQL + ' Equip1='''+P+'''';
		end;
		P := Copy(N,11,1);
		if P <> '_' then
		begin
			if Length(SQL) > 0 then
				SQL := SQL + ' AND';
			SQL := SQL + ' Equip2='''+P+'''';
		end;
		P := Copy(N,12,3);
		if Pos('_',P)=0 then
		begin
			if Length(SQL) > 0 then
				SQL := SQL + ' AND';
			SQL := SQL + ' Num='''+P+'''';
		end;
		if SQL = '' then
			SQL := 'SELECT * FROM AssetsMain'
		else
			SQL := 'SELECT * FROM AssetsMain WHERE' + SQL;
		{ Execute query }
		sqlEditAssets.Close;
		sqlEditAssets.SQL.Clear;
		sqlEditAssets.SQL.Text := SQL;
		sqlEditAssets.Open;
		Screen.Cursor := crDefault;
	end;
end;

{----------------------------------------------------------}

procedure TfrmEditAsset.rgpSelectByClick(Sender: TObject);
begin
	case rgpSelectBy.ItemIndex of
	0:
		begin
			gboxNumber.Enabled := True;
			gboxSelect.Enabled := False;
		end;
	1:
		begin
			gboxNumber.Enabled := False;
			gboxSelect.Enabled := True;
		end;
	end;
end;

{----------------------------------------------------------}
procedure TfrmEditAsset.BitBtn1Click(Sender: TObject);
begin
	frmMain.mnuHelpContentsClick(Sender);
end;

{----------------------------------------------------------}
procedure TfrmEditAsset.sqlEditAssetsAfterScroll(DataSet: TDataSet);
var
	Str : string;
begin
	Screen.Cursor := crSQLWait;
	{ Update Asset Number}
	with sqlEditAssets do
	begin
		str :=	FieldByName('RegionCode').AsString +
						FieldByName('SiteCode').AsString + ' - ' +
						FieldByName('Sys1').AsString +
						FieldByName('Sys2').AsString +
						FieldByName('Sys3').AsString + '  ' +
						FieldByName('Equip1').AsString +
						FieldByName('Equip2').AsString +
						Format('%.3d',[FieldByName('Num').AsInteger]);
	end;
	edAssetNum.Text := Uppercase(Str);
	Screen.Cursor := crDefault;
end;

{----------------------------------------------------------}
procedure TfrmEditAsset.bitbtnOKClick(Sender: TObject);
begin
	if sqlEditAssets.State in [dsEdit, dsInsert] then
		sqlEditAssets.Post;
end;

{----------------------------------------------------------}
procedure TfrmEditAsset.bitbtnCancelClick(Sender: TObject);
begin
	sqlEditAssets.Cancel;
end;

{----------------------------------------------------------}
end.
{----------------------------------------------------------}

