unit uCreateReports;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBCtrls, ExtCtrls, Mask, Db, DBTables, ComCtrls, Buttons,
  RxLookup;

type
  TfrmCreateReport = class(TForm)
    pgcontCreateReport: TPageControl;
    tabName: TTabSheet;
		lblName: TLabel;
    gboxDescription: TGroupBox;
    dbmemoDescription: TDBMemo;
    tabInitial: TTabSheet;
    dbmemoInitialQuery: TDBMemo;
    tabCrossTab: TTabSheet;
    dbmemoCrossTab: TDBMemo;
    tabFinalQuery: TTabSheet;
    dbmemoFinalQuery: TDBMemo;
    tblReports: TTable;
    dsReports: TDataSource;
    bitbtnNew: TBitBtn;
    bitbtnCancel: TBitBtn;
    bitbtnOK: TBitBtn;
    rxdbcomboName: TRxDBLookupCombo;
    bitbtnDelete: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure bitbtnNewClick(Sender: TObject);
		procedure bitbtnCancelClick(Sender: TObject);
		procedure bitbtnOKClick(Sender: TObject);
		procedure rxdbcomboNameChange(Sender: TObject);
    procedure bitbtnDeleteClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCreateReport: TfrmCreateReport;

implementation

{$R *.DFM}


{----------------------------------------------------------}
procedure TfrmCreateReport.FormCreate(Sender: TObject);
begin
	pgcontCreateReport.ActivePage := tabName;
	tblReports.Open;
	tblReports.First;
	rxdbcomboName.KeyValue := tblReports.FieldValues['ReportID'];
	ActiveControl := rxdbcomboName;
end;

{----------------------------------------------------------}
procedure TfrmCreateReport.FormClose(Sender: TObject;
	var Action: TCloseAction);
begin
	tblReports.Close;
end;

{----------------------------------------------------------}
procedure TfrmCreateReport.bitbtnNewClick(Sender: TObject);
var
	strName: string;
begin
	If InputQuery('Create New Report', 'Report Name: ', strName) Then
	begin
		tblReports.Insert;
		tblReports.FieldValues['Name'] := strName;
		tblReports.Post;
		tblReports.Locate('Name', strName, []);
		rxdbcomboName.KeyValue := tblReports.FieldValues['ReportID'];
	end;
end;

{----------------------------------------------------------}
procedure TfrmCreateReport.bitbtnCancelClick(Sender: TObject);
begin
	if tblReports.State in [dsEdit, dsInsert] then
		tblReports.Cancel;
end;

{----------------------------------------------------------}
procedure TfrmCreateReport.bitbtnOKClick(Sender: TObject);
begin
	if tblReports.State in [dsEdit, dsInsert] then
		tblReports.Post;
end;

{----------------------------------------------------------}
procedure TfrmCreateReport.rxdbcomboNameChange(Sender: TObject);
var
	strName: string;
begin
	If rxdbcomboName.Text = '[New Report]' then
		If InputQuery('Create New Report', 'Report Name: ', strName) Then
		begin
			tblReports.Insert;
			tblReports.FieldValues['Name'] := strName;
			tblReports.Locate('Name', strName, []);
		end;
end;

{----------------------------------------------------------}
procedure TfrmCreateReport.bitbtnDeleteClick(Sender: TObject);
begin
	If MessageDlg('Are you sure you want to delete the' + #10 + #13 +
								'report "' + tblReports.FieldValues['Name'] + '"?',
								mtConfirmation, [mbYes, mbNo], 0) = mrYes then
	begin
		tblReports.Delete;
		rxdbcomboName.KeyValue := tblReports.FieldValues['ReportID'];
	end;
end;

{----------------------------------------------------------}
end.
{----------------------------------------------------------}

