unit uCreateEvent;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, RXSpin, Mask, ToolEdit, RxLookup, Db, DBTables,
  ComCtrls, Grids, DBGrids, RXDBCtrl, DBCtrls, DBCGrids;

type
  TfrmCreateEvent = class(TForm)
    pgcontCreateEvent: TPageControl;
    tabBasic: TTabSheet;
    tblEventsMain: TTable;
    dsEventsMain: TDataSource;
    tblEventTypes: TTable;
    dsEventTypes: TDataSource;
    rxdbcomboEventType: TRxDBLookupCombo;
    lblEventType: TLabel;
    dateedDate: TDateEdit;
    rxspinedHour: TRxSpinEdit;
    rxspinedMin: TRxSpinEdit;
    lblEventDate: TLabel;
    lblEventTime: TLabel;
    bitbtnOK: TBitBtn;
    bitbtnCancel: TBitBtn;
    bitbtnAdd: TBitBtn;
    lblH: TLabel;
    lblM: TLabel;
    tabOther: TTabSheet;
    sqlOtherData: TQuery;
    dsOtherData: TDataSource;
    dbgridEventsOther: TDBGrid;
    sqlOtherFields: TQuery;
    dsOtherFields: TDataSource;
    tblEventsOther: TTable;
    dsEventsOther: TDataSource;
    sqlOtherDataGEID: TIntegerField;
    sqlOtherDataGAID: TIntegerField;
    sqlOtherDataFieldName: TStringField;
    sqlOtherDataFieldValue: TFloatField;
    procedure FormCreate(Sender: TObject);
    procedure bitbtnCancelClick(Sender: TObject);
    procedure bitbtnOKClick(Sender: TObject);
    procedure bitbtnAddClick(Sender: TObject);
    procedure dateedDateExit(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure rxdbcomboEventTypeChange(Sender: TObject);
    procedure pgcontCreateEventChange(Sender: TObject);
    procedure dbgridEventsOtherEditButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCreateEvent: TfrmCreateEvent;

implementation

uses uSelectAsset;

{$R *.DFM}

{----------------------------------------------------------}
procedure TfrmCreateEvent.FormCreate(Sender: TObject);
begin
	pgcontCreateEvent.ActivePage := tabBasic;
  tabOther.TabVisible := False;
  frmCreateEvent.ActiveControl := rxdbcomboEventType;
	tblEventsMain.Open;
  tblEventsMain.Insert;
  tblEventTypes.Open;
end;

{----------------------------------------------------------}
procedure TfrmCreateEvent.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
	tblEventsMain.Close;
  tblEventTypes.Close;
end;

{----------------------------------------------------------}
procedure TfrmCreateEvent.bitbtnCancelClick(Sender: TObject);
begin
	If tblEventsMain.State = dsEdit then tblEventsMain.Cancel;
end;

{----------------------------------------------------------}
procedure TfrmCreateEvent.bitbtnOKClick(Sender: TObject);
begin
	If sqlOtherData.State in [dsEdit, dsInsert] then
  	sqlOtherData.Post;
end;

{----------------------------------------------------------}
procedure TfrmCreateEvent.bitbtnAddClick(Sender: TObject);
begin
	If sqlOtherData.State in [dsEdit, dsInsert] then
  	sqlOtherData.Post;
  tabBasic.TabVisible := True;
  pgcontCreateEvent.ActivePage := tabBasic;
  tabOther.TabVisible := False;
  tblEventsMain.Insert;
  rxdbcomboEventType.SetFocus;
end;

{----------------------------------------------------------}
procedure TfrmCreateEvent.dateedDateExit(Sender: TObject);
begin
	tblEventsMain.FieldValues['DateTime'] := StrToDate(dateedDate.Text) +
  	EncodeTime(Trunc(rxspinedHour.Value), Trunc(rxspinedMin.Value), 0, 0);
end;

{----------------------------------------------------------}
procedure TfrmCreateEvent.rxdbcomboEventTypeChange(Sender: TObject);
begin
	If rxdbcomboEventType.Text = '' then
  	tabOther.TabVisible := False
  Else
  	tabOther.TabVisible := True;
end;

{----------------------------------------------------------}
procedure TfrmCreateEvent.pgcontCreateEventChange(Sender: TObject);
begin
	if pgcontCreateEvent.ActivePage = tabOther then
  begin
	  tabBasic.TabVisible := False;
		sqlOtherData.Close;
		tblEventsMain.FieldValues['DateTime'] := StrToDate(dateedDate.Text) +
	  	EncodeTime(Trunc(rxspinedHour.Value), Trunc(rxspinedMin.Value), 0, 0);
		If tblEventsMain.State in [dsEdit, dsInsert] then
	  	tblEventsMain.Post;
		sqlOtherFields.Open;
		tblEventsOther.Open;
		sqlOtherFields.First;
		while not sqlOtherFields.EOF do
	  begin
			tblEventsOther.Insert;
			tblEventsOther.FieldValues['GEID']	:= tblEventsMain.FieldValues['GEID'];
			tblEventsOther.FieldValues['Type']	:= tblEventsMain.FieldValues['Type'];
			tblEventsOther.FieldValues['FieldNum']		:= sqlOtherFields.FieldValues['FieldNum'];
			tblEventsOther.FieldValues['FieldValue']	:= Null;
			tblEventsOther.FieldValues['GAID']	:= Null;
			tblEventsOther.Post;
			sqlOtherFields.Next;
		end;
    tblEventsOther.Close;
		sqlOtherFields.Close;
		Application.ProcessMessages;
		{ Display the new fields for the user to complete }
		sqlOtherData.Open;
{
		if sqlOtherData.CanModify then
			MessageDlg('YES', mtInformation, [mbOK], 0)
		else
			MessageDlg('NO', mtInformation, [mbOK], 0);
}
	end;
end;

{----------------------------------------------------------}
procedure TfrmCreateEvent.dbgridEventsOtherEditButtonClick(
	Sender: TObject);
var
	lGAID: LongInt;
	lID : String;
begin
	if SelectAsset(lGAID, lID) then
	begin
		sqlOtherData.Edit;
		dbgridEventsOther.SelectedField.Value := lGAID;
		sqlOtherData.Post;
	end;
end;

end.
{----------------------------------------------------------}
